$(function() {

// large gestures first screen

    var squareC = Raphael('canvas-sq', 110, 110);
    var square = "M20,20h70v70h-70V20M10,10";
    var sqfinal = "M20,20h70v70h-70V20M10,10";
    drawline(squareC,"#fdc2ff", square);

    var rrframeC = Raphael('canvas-rr', 110, 110);
    var rrframe = "M20,20h70v70h-70V20M90,100c-5.5,0-10-4.5-10-10s4.5-10,10-10s10,4.5,10,10S96.2,100,90,100";
    var rrframefinal = "M80.7,90.7h-50c-5.5,0-10-4.5-10-10v-50c0-5.5,4.5-10,10-10h50c5.5,0,10,4.5,10,10v50C90.7,86.2,86.2,90.7,80.7,90.7z";
    drawline(rrframeC,"#fdc2ff", rrframe);

    var imageC = Raphael('canvas-img', 110, 110);
    var image = "M20.7,20.7l70,70M90.7,20.7l-70,70";
    var imagefinal = "M20.7,20.7l70,70M90.7,20.7l-70,70M20.7,20.7h70v70h-70V20.7";
    drawline(imageC,"#fdc2ff", image);

    var headlineC = Raphael('canvas-h', 110, 110);
    var headline = "M16.7,35.7h70v40h-70V35.7M93.7,77.7c-0.6,0-1-0.4-1-1s0.4-1,1-1s1,0.4,1,1S94.2,77.7,93.7,77.7z";
    var headlinefinal = "Lorem";
    var posx ="20";
    var posy ="55";
    drawline(headlineC,"#fdc2ff", headline);

    var eraseC = Raphael('canvas-erase', 110, 110);
    var erase = "M12,80c2.6-9.1,16.4-38.7,23.3-46.1c4.5-4.8,7.4-4,8.4-3.4c1.9,1.1,2.6,3.8,1.8,6.6c-0.4,1.2-1.1,3.3-2,5.8c-2.9,8.1-7.7,21.5-7.9,29.1c-0.1,4.4,1.4,7.6,3.7,8.2c2.5,0.6,5.3-1.8,7.4-6.3c6.1-13.2,11.8-23,16.7-29.3c3-3.8,6.5-5.5,8.9-4.3c2.7,1.3,3.3,5.7,1.7,12c-0.7,2.9-1.4,5.4-1.9,7.6c-2,7.9-2.9,11.5-3.7,16.4c-0.4,2.5,0.2,4.5,1.6,4.9c1.8,0.6,5-1.3,8.6-8.3C84.9,60.7,89.2,56.1,93,53c1.6-1.3,3.4-1.6,4.7-0.7c3.1,2.1,1.2,8.7,0.2,11.5c-3,8.8-2.2,11.8-1.7,13.8c0.1,0.5,0.3,1,0.3,1.5";
    var erasefinal = "M20.7,20.7l70,70M90.7,20.7l-70,70M20.7,20.7h70v70h-70V20.7";
    drawline(eraseC,"#fdc2ff", erase);



// smaller gestures

    var sm_eraseC = Raphael('sm-canvas-erase', 80, 80);
    var sm_erase = "M8,59.5c1.9-7.1,12.2-30.2,17.3-36c3.3-3.8,5.5-3.1,6.3-2.6c1.4,0.8,2,3,1.3,5.2c-0.3,1-0.8,2.5-1.5,4.5c-2.1,6.3-5.7,16.8-5.9,22.7c-0.1,3.4,1,5.9,2.8,6.4c1.8,0.4,3.9-1.4,5.5-4.9c4.6-10.3,8.7-18,12.5-22.9c2.2-3,4.9-4.3,6.6-3.4c2,1,2.4,4.4,1.3,9.3c-0.5,2.3-1,4.2-1.4,5.9c-1.5,6.1-2.2,9-2.8,12.8c-0.3,2,0.2,3.5,1.2,3.9c1.3,0.5,3.7-1,6.4-6.5c4.7-9.5,7.9-13.1,10.7-15.5c1.2-1,2.5-1.2,3.5-0.5c2.3,1.7,0.9,6.8,0.2,9c-2.3,6.9-1.7,9.2-1.3,10.8c0.1,0.4,0.2,0.8,0.2,1.2";
    var sm_erasefinal = "M20.7,20.7l70,70M90.7,20.7l-70,70M20.7,20.7h70v70h-70V20.7";
    drawline(sm_eraseC,"#fdc2ff", sm_erase);

    $(".sm_erase").click(function(){
    if($(this).attr('alt') =='active')
        {return}
     else{
     animateErase(sm_eraseC, "sm_erase", "#fdc2ff", sm_erase, sm_erasefinal, 2000);
    }
    });

    var sm_headlineC = Raphael('sm-canvas-h', 80, 80);
    var sm_headline = "M9,25.5h59v30H9V25.5M75.5,55.5c-0.6,0-1-0.4-1-1s0.4-1,1-1s1,0.4,1,1S76.1,55.5,75.5,55.5z";
    var sm_headlinefinal = "Lorem";
    var sposx ="10";
    var sposy ="40";
    var headfont = "24";
    drawline(sm_headlineC,"#fdc2ff", sm_headline);

    $(".sm_headline").click(function(){
    if($(this).attr('alt') =='active')
        {return}
     else{
     animateText(sm_headlineC, "sm_headline", "#fdc2ff", sm_headline, sm_headlinefinal,sposx,sposy, 1500, headfont);
    }
    });

    var sm_multilineC = Raphael('sm-canvas-ml', 80, 80);
    var sm_multiline = "M10.5,31h60M10.5,41h60M10.5,51h50M69.5,52c-0.6,0-1-0.4-1-1s0.4-1,1-1s1,0.4,1,1S70.1,52,69.5,52z";
    var sm_multilinefinal = "Dis facilisis, nunc\nAugue vut,dolor!\nDiam! Hac";
    var mposx ="10";
    var mposy ="40";
    var multifont ="10";
    drawline(sm_multilineC,"#fdc2ff", sm_multiline);

    $(".sm_multiline").click(function(){
    if($(this).attr('alt') =='active')
        {return}
     else{
     animateText(sm_multilineC, "sm_multiline", "#fdc2ff", sm_multiline, sm_multilinefinal,mposx,mposy, 1500, multifont);
    }
    });

    var sm_paragraphC = Raphael('sm-canvas-pg', 80, 80);
    var sm_paragraph = "M10.5,10.5h60v60h-60V10.5M20.5,29h40M20.5,41h40M20.5,53h40";
    var sm_paragraphfinal = "Dis facilisis, nunc est in elementum.\nAugue vut, nec pulvinar, dolor! Diam! Hac cum augue,\nturpis! Scelerisque, elit turpis etiam mus,\npenatibus elit dapibus? In cum magna tristique\nmagna est magna.";
    var pposx ="10";
    var pposy ="40";
    var parafont ="7";
    drawline(sm_paragraphC,"#fdc2ff", sm_paragraph);

    $(".sm_paragraph").click(function(){
    if($(this).attr('alt') =='active')
        {return}
     else{
     animateText(sm_paragraphC, "sm_paragraph", "#fdc2ff", sm_paragraph, sm_paragraphfinal,pposx,pposy, 1500, parafont);
    }
    });


    var small = {
        sm_squareC : Raphael('sm-canvas-sq', 80, 80),
        sm_square : "M10.5,10.5h60v60h-60V10.5",
        sm_squarefinal : "M10.5,10.5h60v60h-60V10.5",
        sm_circleC : Raphael('sm-canvas-c', 80, 80),
        sm_circle : "M40.4,70.5c-16.6,0-29.9-13.4-29.9-30s13.4-30,30-30s30,13.4,30,30S57.1,70.5,40.4,70.5",
        sm_circlefinal : "M40.4,70.5c-16.6,0-29.9-13.4-29.9-30s13.4-30,30-30s30,13.4,30,30S57.1,70.5,40.4,70.5",
        sm_roundRC : Raphael('sm-canvas-rr', 80, 80),
        sm_roundR : "M10.5,10.5h60v60h-60V10.5M70.5,78c-4.1,0-7.5-3.4-7.5-7.5s3.4-7.5,7.5-7.5s7.5,3.4,7.5,7.5S74.6,78,70.5,78",
        sm_roundRfinal : "M61.9,70.5H19.1c-4.7,0-8.6-3.8-8.6-8.6V19.1c0-4.7,3.8-8.6,8.6-8.6h42.9c4.7,0,8.6,3.8,8.6,8.6v42.9C70.5,66.7,66.7,70.5,61.9,70.5z",
        sm_chamRC : Raphael('sm-canvas-cr', 80, 80),
        sm_chamR : "M10.5,10.5h60v60h-60V10.5M75,59L60,74",
        sm_chamRfinal : "M70.5,60.6l-9.9,9.9H20.4l-9.9-9.9V20.4l9.9-9.9h40.2l9.9,9.9V60.6z",
        sm_imageC : Raphael('sm-canvas-i', 80, 80),
        sm_image : "M10.5,10.5l60,60M70.5,10.5l-60,60",
        sm_imagefinal : "M10.5,10.5h60v60h-60V10.5M10.5,10.5l60,60M70.5,10.5l-60,60",
        sm_image2C : Raphael('sm-canvas-i2', 80, 80),
        sm_image2 : "M10.5,10.5h60v60h-60V10.5M10.5,10.5l60,60M70.5,10.5l-60,60",
        sm_image2final : "M10.5,10.5h60v60h-60V10.5M10.5,10.5l60,60M70.5,10.5l-60,60",
        sm_roundimageC : Raphael('sm-canvas-ri', 80, 80),
        sm_roundimage : "M10.5,10.5h60v60h-60V10.5M10.5,10.5l60,60M70.5,10.5l-60,60M70.5,78c-4.1,0-7.5-3.4-7.5-7.5s3.4-7.5,7.5-7.5s7.5,3.4,7.5,7.5S74.6,78,70.5,78",
        sm_roundimagefinal : "M61.9,70.5H19.1c-4.7,0-8.6-3.8-8.6-8.6V19.1c0-4.7,3.8-8.6,8.6-8.6h42.9c4.7,0,8.6,3.8,8.6,8.6v42.9C70.5,66.7,66.7,70.5,61.9,70.5zM13,13l55,55M68,13L13,68",
        sm_circleimageC : Raphael('sm-canvas-ci', 80, 80),
        sm_circleimage : "M40.4,70.5c-16.6,0-29.9-13.4-29.9-30s13.4-30,30-30s30,13.4,30,30S57.1,70.5,40.4,70.5M19.5,19.5l42,42M61.5,19.5l-42,42",
        sm_circleimagefinal : "M40.4,70.5c-16.6,0-29.9-13.4-29.9-30s13.4-30,30-30s30,13.4,30,30S57.1,70.5,40.4,70.5M19.5,19.5l42,42M61.5,19.5l-42,42",
        sm_triangleC : Raphael('sm-canvas-t', 80, 80),
        sm_triangle : "M8.4,71l32.5-60l32.5,60H8.4",
        sm_trianglefinal : "M8.4,71l32.5-60l32.5,60H8.4",
        sm_cornerC : Raphael('sm-canvas-cnr', 80, 80),
        sm_corner : "M10.5,70.5l60-60v60H10.5",
        sm_cornerfinal : "M10.5,70.5l60-60v60H10.5",
        sm_polygonC : Raphael('sm-canvas-p', 80, 80),
        sm_polygon : "M41,10l26,15v30L41,70L15,55V25L41,10",
        sm_polygonfinal : "M41,10l26,15v30L41,70L15,55V25L41,10",
        sm_lineC : Raphael('sm-canvas-l', 80, 80),
        sm_line : "M10.5,41h60",
        sm_linefinal : "M10.5,41h60"                                
    }

    var gestures_all = [ "sm_square" , "sm_circle", "sm_roundR", "sm_chamR", "sm_image", "sm_image2", "sm_roundimage", "sm_circleimage", "sm_triangle", "sm_corner", "sm_polygon", "sm_line"];

    for(i=0; i<12; i++){
        drawline(small[gestures_all[i]+"C"], "#fdc2ff",small[gestures_all[i]]);
    }




/* Small Gestures Click */
$(".gesture-click").click(function(){
    var data = $(this).attr("data");

if($(this).attr('alt') =='active')
    {return}
else{
    animateLine(small[data+"C"], data, "#fdc2ff", small[data], small[data+"final"], 1500)
    }
})






/* Big Gestures Click */

$(".square").click(function(){
    if($(this).attr('alt') =='active')
    {return}
 else{
    animateLine(squareC, "square", "#fdc2ff", square, sqfinal, 1500)
    }
}); //click

$(".rounded-rectangle").click(function(){
if($(this).attr('alt') =='active')
    {return}
 else{
 animateLine(rrframeC, "rounded-rectangle", "#fdc2ff", rrframe, rrframefinal, 2000);
}
});

$(".image").click(function(){
if($(this).attr('alt') =='active')
    {return}
 else{
 animateLine(imageC, "image", "#fdc2ff", image, imagefinal, 1500);
}
});

$(".erase").click(function(){
if($(this).attr('alt') =='active')
    {return}
 else{
 animateErase(eraseC, "erase", "#fdc2ff", erase, erasefinal, 2000);
}
});

$(".headline").click(function(){
if($(this).attr('alt') =='active')
    {return}
 else{
 animateText(headlineC, "headline", "#fdc2ff", headline, headlinefinal,posx,posy, 1500, headfont);
}
});

});

drawline = function(canvas,colorNumber,pathString){
        canvas.clear();
        canvas.path(pathString).attr({
                    stroke: colorNumber, 
                    "stroke-width":2,
                    "stroke-linecap":"round",
                    fill: "rgba(0,0,0,0.01)"
                });

}

drawshape = function(canvas,shapeString){
        canvas.clear();
        canvas.path(shapeString).attr({
                    stroke: "#a5a5a5", 
                    "stroke-width":1,
                    "stroke-linecap":"round",
                    fill: "#303030"
                });

}
drawtext= function(canvas,textString, posx, posy,fontsize){
        canvas.clear();
        canvas.text(posx,posy,textString).attr({
                    "font-size": fontsize,
                    "text-anchor": "start", 
                    fill: "#a5a5a5"
                });

}

animateLine = function(canvas, hoverDivName, colorNumber, pathString, shapeString, duration) {

        

        canvas.clear();
        $('.' + hoverDivName).attr('alt', 'active');
        var line = canvas.path(pathString).attr({
            stroke: colorNumber
        });
        var length = line.getTotalLength();

        $('path[fill*="none"]').animate({
            'to': 1
        }, {
            duration: duration,
            step: function(pos, fx) {
                var offset = length * fx.pos;
                var subpath = line.getSubpath(0, offset);
                canvas.clear();
                canvas.path(subpath).attr({
                    stroke: colorNumber, 
                    "stroke-width":2,
                    "stroke-linecap":"round"
                });
            }, 
            complete: function(){
                $('.' + hoverDivName).find('path[fill*="none"]').attr({
                    stroke: "#007aff"
                 }).delay(500).animate({ 
                    opacity : 0,
                }, 1000,
                function () { 
                    drawshape(canvas,shapeString);
                    $('path[fill*="#303030"]').delay(800).animate({ 
                        opacity : 0,
                    }, 1000,
                    function () { 
                        drawline(canvas,colorNumber,pathString);
                        $('.' + hoverDivName).attr('alt', 'notactive');

                        });
                });
                    

            }
        }
        );//animate
}; //animateLine

animateText = function(canvas, hoverDivName, colorNumber, pathString, textString, posx, posy, duration, fontsize) {

        canvas.clear();

        $('.' + hoverDivName).attr('alt', 'active');
        var line = canvas.path(pathString).attr({
            stroke: colorNumber
        });
        var length = line.getTotalLength();

        $('path[fill*="none"]').animate({
            'to': 1
        }, {
            duration: duration,
            step: function(pos, fx) {
                var offset = length * fx.pos;
                var subpath = line.getSubpath(0, offset);
                canvas.clear();
                canvas.path(subpath).attr({
                    stroke: colorNumber, 
                    "stroke-width":2,
                    "stroke-linecap":"round"
                });
            }, 
            complete: function(){
                $('.' + hoverDivName).find('path[fill*="none"]').attr({
                    stroke: "#007aff"
                 }).delay(500).animate({ 
                    opacity : 0,
                }, 1000,
                function () {
                    drawtext(canvas,textString, posx, posy,fontsize);
                    $('.' + hoverDivName).find('text').delay(800).animate({ 
                        opacity : 0,
                    }, 1000,
                    function () { 
                        drawline(canvas,colorNumber,pathString);
                        $('.' + hoverDivName).attr('alt', 'notactive');

                        });
                });
                    

            }
        }
        );//animate
}; //animateLine

animateErase = function(canvas, hoverDivName, colorNumber, pathString, shapeString, duration) {

        canvas.clear();
        eraseAnimation(hoverDivName);
        //$('.' + hoverDivName +">.shapes").removeClass("hidden");
        $('.' + hoverDivName).attr('alt', 'active');
        var line = canvas.path(pathString).attr({
            stroke: colorNumber
        });
        var length = line.getTotalLength();

        $('path[fill*="none"]').animate({
            'to': 1
        }, {
            duration: duration,
            step: function(pos, fx) {
                var offset = length * fx.pos;
                var subpath = line.getSubpath(0, offset);
                canvas.clear();
                canvas.path(subpath).attr({
                    stroke: colorNumber, 
                    "stroke-width":2,
                    "stroke-linecap":"round"
                });
            }, 
            complete: function(){
               /* $('.' + hoverDivName).find('path[fill*="none"]').attr({
                    stroke: "#007aff"
                 }).delay(500).animate({ 
                    opacity : 0,
                }, 1000);*/
                canvas.clear();
                drawline(canvas,colorNumber,pathString);
                $('.' + hoverDivName).attr('alt', 'notactive');
                    

            }
        }
        );//animate
}; //animateLine


eraseAnimation = function(clicker){
    console.log("erased");
    $("."+clicker+"> .shapes").removeClass("hidden");
        $("."+clicker+"> .shapes > .square").fadeOut(1000, function(){
            $("."+clicker+"> .shapes > .circle").fadeOut(600, function(){
                $("."+clicker+"> .shapes > .triangle").fadeOut(400,function(){
                    $("."+clicker+"> .shapes").addClass("hidden").children().css("display", "block");
                });
            });
        });

}